#define INCL_DOSNLS     /* National Language Support values */
#define INCL_DOSERRORS  /* DOS Error values */
#include <os2.h>
#include <stdio.h>
#include <string.h>
 
COUNTRYCODE ctrycodeInfo      = {0};            /* Country code information */
UCHAR       uchDBCSInfo[12]   = {0};            /* DBCS information buffer */
static INT  first = 1;
       
/* Get the double-byte character set vector from the country file. */
int GetDBCSVector(VOID) 
{
    APIRET      rc                = NO_ERROR;   /* A return code */
 
    ctrycodeInfo.country = 0;                   /* Current country */
    ctrycodeInfo.codepage = 0;                  /* Current codepage */
 
    rc = DosQueryDBCSEnv(sizeof(uchDBCSInfo),   /* Size of buffer */
                         &ctrycodeInfo,         /* Country code information */
                         (PCHAR)uchDBCSInfo);   /* DBCS information buffer */
    return rc;
}
 
/* Eval the double-byte character set 1st Byte */
INT isDBCS1stByte(INT DBCS1stByte)
{
    INT     RetValue = 0;
    int     i;

    if(first)
    {
        (void)GetDBCSVector();
        first = 0;
    }

    for(i =  0; i < sizeof(uchDBCSInfo);  i += 2)
    {
        if(uchDBCSInfo[i] == 0)
            break;
        if(DBCS1stByte >= uchDBCSInfo[i] && DBCS1stByte <= uchDBCSInfo[i + 1])
        {
            RetValue = 1;
            break;
        }
    }
    return RetValue;
}

/* Get the last-character. (sbcs/dbcs) */
int lastchar(const char *string)
{
    UCHAR *s;
    int c = 0, i, len = strlen(string);
    s = (UCHAR *)string;
    for(i = 0; i < len; i++)
    {
        c = *(s + i);
        if(isDBCS1stByte(c))
        {
            c = (c << 8) + *(s + i + 1);
            i++;
        }
    }
    return c;
}

#ifdef strchr
 #undef strchr
#endif
#ifdef strrchr
 #undef strrchr
#endif

/* byte step DBCS type strchr() (but. different wstrchr()) */
char *strchr(const char *string, int c)
{
    char *s;
    int  i, len = strlen(string);
    unsigned int ch;
    s = (char *)string;
    for(i = 0; i < len; i++)
    {
        ch = *(s + i);
        if(isDBCS1stByte(ch))
            ch = (ch << 8) + *(s + i + 1);
        if(c == ch)
            return (s + i);
        if(ch & 0xFF00)
            i++;
    }
    return NULL;
}
/* byte step DBCS type strrchr() (but. different wstrrchr()) */
char *strrchr(const char *string, int c)
{
    char *s, *lastpos;
    s = (char *)string;
    lastpos = strchr(s, c);
    if(!lastpos)
        return NULL;
    for(;;)
    {
        s = lastpos + 1;
        s = strchr(s, c);
        if(!s)
            break;
        lastpos = s;
    }
    return lastpos;
}

int tolower(int c)
{
    if(c >= 'A' && c <= 'Z')
        return (c | 0x20);
    else
        return c;
}
int toupper(int c)
{
    if(c >= 'a' && c <= 'z')
        return (c & 0x5F);
    else
        return c;
}
int stricmp(const char *string1, const char *string2)
{
    char s1[2048], s2[2048], *s;
    strcpy(s1, string1);
    strcpy(s2, string2);
    s = s1;
    while(*s)
    {
        *s = toupper(*s);
        if(isDBCS1stByte(*s))
            s++;
        s++;
    }
    s = s2;
    while(*s)
    {
        *s = toupper(*s);
        if(isDBCS1stByte(*s))
            s++;
        s++;
    }
    return strcmp(s1, s2);
}
int strnicmp(const char *string1, const char *string2, unsigned int n)
{
    char s1[2048], s2[2048], *s;
    strcpy(s1, string1);
    strcpy(s2, string2);
    s = s1;
    while(*s)
    {
        *s = toupper(*s);
        if(isDBCS1stByte(*s))
            s++;
        s++;
    }
    s = s2;
    while(*s)
    {
        *s = toupper(*s);
        if(isDBCS1stByte(*s))
            s++;
        s++;
    }
    return strncmp(s1, s2, n);
}
