/* (OAX) */
#define INCL_DOSSEMAPHORES
#define INCL_WIN
#include <os2.h>
#include <stdio.h>
#include <string.h>
#include "pms11.h"

HAB hab;
HWND hpopup;   /* popup menu handle */
HPOINTER hicon;   /* icon handle */
int options = OPT_TITLEBAR;   /* show titlebar */
int update  = 2000;           /* update interval in milliseconds */

APIRET ARTemInput(int *n1, int *n2, int *n3);

void UpdateDisplay(HWND hwnd)
{
    char buf[64];
    int n1, n2, n3;
    APIRET          ulrc;               /* Return code */

    ulrc = ARTemInput(&n1, &n2, &n3);

    if(!ulrc)
    {
        sprintf(buf, "%4d ", n1);
        WinSetDlgItemText(hwnd, IDD_DATA1, buf);
        sprintf(buf, "%4d ", n2);
        WinSetDlgItemText(hwnd, IDD_DATA2, buf);
        sprintf(buf, "%4d ", n3);
        WinSetDlgItemText(hwnd, IDD_DATA3, buf);
    } else {
        //sprintf(buf, " na  ");
    	strcpy(buf, " na  ");
        WinSetDlgItemText(hwnd, IDD_DATA1, buf);
        WinSetDlgItemText(hwnd, IDD_DATA2, buf);
        WinSetDlgItemText(hwnd, IDD_DATA3, buf);
    }
}

static MRESULT EXPENTRY SetupDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
  {
  char buf[64];

  switch (msg)
     {
     case WM_INITDLG:
        return (MRESULT)0;

     case WM_CONTROL:
        break;

     case WM_DESTROY:
        break;
     }

  return WinDefDlgProc(hwnd, msg, mp1, mp2);
  }

void ShowTitleBar(HWND hwnd, BOOL show, BOOL resize)
  {
  HWND t;
  SWP size;
  int delta;

  WinCheckMenuItem(hpopup, IDM_TITLEBAR, show);
  t = WinWindowFromID(hwnd, FID_TITLEBAR);
  if (resize)
     {
     WinQueryWindowPos(t, &size);
     delta = size.cy;
     WinQueryWindowPos(hwnd, &size);
     if (show)
        size.cy += delta;
     else
        size.cy -= delta;
     WinSetWindowPos(hwnd, 0, 0, 0, size.cx, size.cy, SWP_SIZE);
     }
  WinShowWindow(t, show);
  WinShowWindow(WinWindowFromID(hwnd, FID_SYSMENU), show);
  WinShowWindow(WinWindowFromID(hwnd, FID_MINMAX), show);
  }

void InitWindow(HWND hwnd)
  {
  ULONG x,y;

  WinRestoreWindowPos(AppName, "WindowPos", hwnd);
  y = sizeof(x);
  if (PrfQueryProfileData(HINI_USERPROFILE, AppName, "Options", &x, &y))
     options = x;
  WinSetAccelTable(hab, WinLoadAccelTable(hab, 0, ID_S11), hwnd);

  UpdateDisplay(hwnd);
  WinStartTimer(hab, hwnd, ID_S11, update);
  WinSendMsg(hwnd, WM_SETICON, MPFROMP(hicon), MPVOID); /* setting the icon. Is there an easier way? */
  ShowTitleBar(hwnd, (options & OPT_TITLEBAR), FALSE);   /* don't resize, since the window size was also restored */
  }

static MRESULT EXPENTRY ClientWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  static int firstPopup = 1;
  switch (msg)
     {
     case WM_INITDLG:
        {
           InitWindow(hwnd);
        return (MRESULT)0;
        }

     case WM_COMMAND:
        {
        switch (SHORT1FROMMP(mp1))
           {
           case IDM_ONTOP:
              options ^= OPT_ONTOP;
              WinCheckMenuItem(hpopup, IDM_ONTOP, (options & OPT_ONTOP));
              return (MRESULT)0;

           case IDM_TITLEBAR:
              options ^= OPT_TITLEBAR;
              ShowTitleBar(hwnd, (options & OPT_TITLEBAR), TRUE);
              return (MRESULT)0;

           case IDM_EXIT:
              WinSendMsg(hwnd, WM_CLOSE, MPVOID, MPVOID);
              return (MRESULT)0;

           case DID_CANCEL:
              return 0;
           }
        }
        break;

     case WM_ACTIVATE:
        {
        ShowTitleBar(hwnd, (options & OPT_TITLEBAR), FALSE);  /* avoid activating a disabled titlebar */
        }
        break;

     case WM_TIMER:
        {
        UpdateDisplay(hwnd);
        if (options & OPT_ONTOP)             /* is there a better way to do this? */
           WinSetWindowPos(hwnd, HWND_TOP, 0, 0, 0, 0, SWP_ZORDER);
        }
        break;

     case WM_BUTTON1DOWN:
        {
        WinSendMsg(hwnd, WM_TRACKFRAME, MPFROMSHORT(TF_MOVE), MPVOID);
        }
        break;

     case WM_BUTTON1UP:
        {
        WinSendMsg(hwnd, WM_TRACKFRAME, MPVOID, MPVOID);
        }
        break;

     case WM_BUTTON2DOWN:
        {
       #if 1
        if(firstPopup)
        {
           hpopup = WinLoadMenu(hwnd, 0, ID_S11);
           WinCheckMenuItem(hpopup, IDM_ONTOP, (options & OPT_ONTOP));
           WinCheckMenuItem(hpopup, IDM_TITLEBAR, (options & OPT_TITLEBAR));
           firstPopup = 0;
        }
       #endif
        WinPopupMenu(hwnd, hwnd, hpopup, SHORT1FROMMP(mp1), SHORT2FROMMP(mp1), 0,
                    PU_HCONSTRAIN |
                    PU_VCONSTRAIN |
                    PU_MOUSEBUTTON1 |
                    PU_MOUSEBUTTON2 |
                    PU_KEYBOARD);
        return (MRESULT)0;
        }

     case WM_CLOSE:
        {
          WinDestroyWindow(hpopup);
         WinStoreWindowPos(AppName, "WindowPos", hwnd);
         PrfWriteProfileData(HINI_USERPROFILE, AppName, "Options", &options, sizeof(options));
         //return (MRESULT)0;
        }
     }
  return WinDefDlgProc(hwnd,msg,mp1,mp2);
  }

int main (int argc, char **argv)
{
  HMQ hmq;
  QMSG qmsg;
  int result;
  APIRET ulrc;
  HMTX   hmtx;
  ULONG  flAttr;
  BOOL32 fState;
  /* N̋֎~ by (oax) */
  ulrc = DosOpenMutexSem("\\SEM32\\PMS11", &hmtx);
  if(!ulrc)
  {
    DosCloseMutexSem(hmtx);
    return 0;
  }
  flAttr = 0;
  fState = 0;
  ulrc = DosCreateMutexSem("\\SEM32\\PMS11", &hmtx, flAttr, fState);
  if(ulrc)
     return -1;

  hab = WinInitialize(0);
  hmq = WinCreateMsgQueue(hab, 0);
  hicon = WinLoadFileIcon(argv[0], FALSE);   /* how do you load an icon from a resource? */
  result = WinDlgBox(HWND_DESKTOP, HWND_DESKTOP, ClientWndProc, 0, ID_S11, NULL);
  WinFreeFileIcon(hicon);
  WinDestroyMsgQueue(hmq);
  WinTerminate(hab);

  DosCloseMutexSem(hmtx);
  return result;
}
